# PostWid Installer Script
$ErrorActionPreference = "Stop"

$SourceDir = "$PSScriptRoot\build\exe.win-amd64-3.14"
$TargetDir = "$env:LOCALAPPDATA\PostWid"
$ExePath = "$TargetDir\PostWid.exe"
$ShortcutPath = "$env:USERPROFILE\Desktop\PostWid.lnk"
$IconPath = "$TargetDir\img\icon.ico"

Write-Host "Installing PostWid..." -ForegroundColor Cyan

# 1. Check if source exists
if (-not (Test-Path $SourceDir)) {
    Write-Error "Source build directory not found. Please run build setup first."
}

# 2. Cleanup old install
if (Test-Path $TargetDir) {
    Write-Host "   Removing old version..." -ForegroundColor Gray
    Remove-Item -Path $TargetDir -Recurse -Force
}

# 3. Copy files
Write-Host "   Copying files to $TargetDir..." -ForegroundColor Gray
Copy-Item -Path $SourceDir -Destination $TargetDir -Recurse

# 4. Create Shortcut
Write-Host "   Creating Desktop Shortcut..." -ForegroundColor Gray
$WshShell = New-Object -ComObject WScript.Shell
$Shortcut = $WshShell.CreateShortcut($ShortcutPath)
$Shortcut.TargetPath = $ExePath
$Shortcut.WorkingDirectory = $TargetDir
$Shortcut.IconLocation = $IconPath
$Shortcut.Save()

Write-Host "Installation Complete!" -ForegroundColor Green
Write-Host "You can now launch PostWid from your Desktop." -ForegroundColor Green
Start-Sleep -Seconds 3
